/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.questtypes;

import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.global.GuiNPCManageQuest;
import noppes.npcs.client.gui.global.GuiQuestEdit;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcCheckBox;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.constants.EnumQuestTask;
import noppes.npcs.controllers.BorderController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.quests.QuestObjective;
import noppes.npcs.util.Util;

public class GuiNpcQuestTypeKill
extends SubGuiInterface
implements ITextfieldListener,
ICustomScrollListener {
    public GuiScreen parent;
    private GuiCustomScroll scroll;
    private final QuestObjective task;
    private final Map<Integer, Integer> dataDimIDs = new HashMap<Integer, Integer>();
    private final Map<String, EntityNPCInterface> dataNPCs = new HashMap<String, EntityNPCInterface>();
    private final DecimalFormat df = new DecimalFormat("#.#");

    public GuiNpcQuestTypeKill(EntityNPCInterface npc, QuestObjective taskObj, GuiScreen gui) {
        super(npc);
        this.setBackground("menubg.png");
        this.title = new TextComponentTranslation("quest.title.kill", new Object[0]).func_150254_d();
        this.xSize = 356;
        this.ySize = 216;
        this.closeOnEsc = true;
        this.parent = gui;
        this.task = taskObj;
    }

    @Override
    public void func_146284_a(@Nonnull GuiButton guibutton) {
        if (!(guibutton instanceof GuiNpcButton)) {
            super.func_146284_a(guibutton);
            return;
        }
        if (this.task == null) {
            return;
        }
        GuiNpcButton button = (GuiNpcButton)guibutton;
        switch (button.field_146127_k) {
            case 1: {
                this.task.setPartName(((GuiNpcCheckBox)guibutton).isSelected());
                break;
            }
            case 2: {
                this.task.setAndTitle(((GuiNpcCheckBox)guibutton).isSelected());
                break;
            }
            case 4: {
                if (!this.dataDimIDs.containsKey(button.getValue())) {
                    return;
                }
                this.task.dimensionID = this.dataDimIDs.get(button.getValue());
                button.setHoverText(new TextComponentTranslation("quest.hover.compass.dim", new Object[]{"" + this.task.dimensionID}).func_150257_a((ITextComponent)new TextComponentTranslation("quest.hover.compass", new Object[0])).func_150254_d(), new Object[0]);
                break;
            }
            case 5: {
                this.task.setPointOnMiniMap(((GuiNpcCheckBox)guibutton).isSelected());
                break;
            }
            case 10: {
                this.task.pos = new BlockPos(Math.floor(this.field_146297_k.field_71439_g.field_70165_t), Math.floor(this.field_146297_k.field_71439_g.field_70163_u), Math.floor(this.field_146297_k.field_71439_g.field_70161_v));
                this.task.dimensionID = this.field_146297_k.field_71439_g.field_70170_p.field_73011_w.getDimension();
                this.func_73866_w_();
                break;
            }
            case 11: {
                Client.sendData(EnumPacketServer.TeleportTo, this.task.dimensionID, this.task.pos.func_177958_n(), this.task.pos.func_177956_o(), this.task.pos.func_177952_p());
                break;
            }
            case 66: {
                this.close();
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int lId = 0;
        int x = this.guiLeft + 6;
        int y = this.guiTop + 6;
        GuiNpcButton button = new GuiNpcCheckBox(1, x, y, 208, 14, "quest.kill.part.name", null, this.task.isPartName());
        button.setHoverText("quest.hover.part.name", new Object[0]);
        this.addButton(button);
        button = new GuiNpcCheckBox(2, x, y += 16, 208, 14, new TextComponentTranslation("quest.kill.add.title", new Object[]{new TextComponentTranslation("gui.title", new Object[0]).func_150254_d()}).func_150254_d(), null, this.task.isAndTitle());
        button.setHoverText("quest.hover.add.title", new TextComponentTranslation("gui.title", new Object[0]).func_150254_d());
        this.addButton(button);
        String text = new TextComponentTranslation("quest.player.to", new Object[0]).func_150254_d();
        while (text.contains("<br>")) {
            text = text.replace("<br>", "\n");
        }
        this.addLabel(new GuiNpcLabel(lId++, text, x, y += 16));
        GuiNpcTextField textField = new GuiNpcTextField(0, this, this.field_146289_q, x, y += 22, 180, 14, this.task.getTargetName());
        textField.setHoverText("quest.hover.edit.kill.name", new Object[0]);
        this.addTextField(textField);
        textField = new GuiNpcTextField(1, this, this.field_146289_q, x + 183, y, 24, 14, this.task.getMaxProgress() + "");
        textField.setMinMaxDefault(1L, Integer.MAX_VALUE, 1L);
        textField.setHoverText("quest.hover.edit.kill.value", "2147483647");
        this.addTextField(textField);
        ArrayList<String> list = new ArrayList<String>();
        LinkedHashMap<Integer, List<String>> hts = new LinkedHashMap<Integer, List<String>>();
        int i = 1;
        list.add(0, "\u00a7bPlayer");
        hts.put(0, Collections.singletonList("\u00a77Any player"));
        List npcs = new ArrayList();
        try {
            npcs = this.player.field_70170_p.func_72872_a(EntityNPCInterface.class, new AxisAlignedBB(this.player.func_180425_c()).func_186662_g(32.0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        TreeMap<Float, EntityNPCInterface> map = new TreeMap<Float, EntityNPCInterface>();
        for (EntityNPCInterface npc : npcs) {
            float distance = this.player.func_70032_d((Entity)npc);
            while (map.containsKey(Float.valueOf(distance))) {
                distance += 1.0E-4f;
            }
            map.put(Float.valueOf(distance), npc);
        }
        this.dataNPCs.clear();
        for (Object distance : map.keySet()) {
            String name = ((EntityNPCInterface)((Object)map.get(distance))).func_70005_c_();
            String key = "\u00a7a" + name;
            if (list.contains(key)) continue;
            list.add(key);
            this.dataNPCs.put(key, (EntityNPCInterface)((Object)map.get(distance)));
            ArrayList<String> hoverList = new ArrayList<String>();
            hoverList.add("\u00a77NPC name: \"\u00a7r" + name + '\u00a7' + "7\"");
            hoverList.add("\u00a77Distance Of: \u00a76" + this.df.format(distance));
            hts.put(i++, hoverList);
        }
        ArrayList<String> regNames = new ArrayList<String>();
        for (EntityEntry ent : ForgeRegistries.ENTITIES.getValuesCollection()) {
            Class c = ent.getEntityClass();
            String name = ent.getName();
            try {
                if (!EntityLivingBase.class.isAssignableFrom(c) || EntityNPCInterface.class.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers())) continue;
                regNames.add(name);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
        }
        Collections.sort(regNames);
        list.addAll(regNames);
        for (int j = 0; j < regNames.size(); ++j) {
            hts.put(i++, Collections.singletonList("\u00a77Normal entity name"));
        }
        this.scroll.setListNotSorted(list);
        this.scroll.setHoverTexts(hts);
        this.scroll.setSize(130, 198);
        this.scroll.guiLeft = this.guiLeft + 220;
        this.scroll.guiTop = this.guiTop + 14;
        this.addScroll(this.scroll);
        button = new GuiNpcButton(66, x, this.guiTop + this.ySize - 21, 98, 16, "gui.back");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
        if (this.task.getEnumType() == EnumQuestTask.AREAKILL) {
            this.addLabel(new GuiNpcLabel(lId++, "gui.searchdistance", x, (y += 19) + 3));
            textField = new GuiNpcTextField(2, this, this.field_146289_q, x + 114, y, 40, 14, "" + this.task.getAreaRange());
            textField.setMinMaxDefault(3L, 32L, this.task.getAreaRange());
            textField.setHoverText("quest.hover.area.range", new Object[0]);
            this.addTextField(textField);
            y += 2;
        }
        this.addLabel(new GuiNpcLabel(lId++, "quest.task.pos.set", x, y += 17));
        this.addLabel(new GuiNpcLabel(lId++, "X:", x, (y += 12) + 2));
        TextComponentTranslation compass = new TextComponentTranslation("quest.hover.compass", new Object[0]);
        textField = new GuiNpcTextField(10, this, this.field_146289_q, x + 8, y, 40, 14, "" + this.task.pos.func_177958_n());
        textField.setMinMaxDefault(Integer.MIN_VALUE, Integer.MAX_VALUE, this.task.pos.func_177958_n());
        textField.setHoverText(new TextComponentTranslation("quest.hover.compass.pos", new Object[]{"X"}).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId++, "Y:", x + 51, y + 2));
        textField = new GuiNpcTextField(11, this, this.field_146289_q, x + 59, y, 40, 14, "" + this.task.pos.func_177956_o());
        textField.setMinMaxDefault(Integer.MIN_VALUE, Integer.MAX_VALUE, this.task.pos.func_177956_o());
        textField.setHoverText(new TextComponentTranslation("quest.hover.compass.pos", new Object[]{"Y"}).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId++, "Z:", x + 102, y + 2));
        textField = new GuiNpcTextField(12, this, this.field_146289_q, x + 112, y, 40, 14, "" + this.task.pos.func_177952_p());
        textField.setMinMaxDefault(Integer.MIN_VALUE, Integer.MAX_VALUE, this.task.pos.func_177952_p());
        textField.setHoverText(new TextComponentTranslation("quest.hover.compass.pos", new Object[]{"Z"}).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId++, "R:", this.guiLeft + 160, y + 2));
        textField = new GuiNpcTextField(14, this, this.field_146289_q, x + 164, y, 45, 14, "" + this.task.rangeCompass);
        textField.setMinMaxDefault(0L, 64L, this.task.rangeCompass);
        textField.setHoverText(new TextComponentTranslation("quest.hover.compass.range", new Object[0]).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId++, "D:", x, (y += 17) + 2));
        int p = 0;
        i = 0;
        List<Integer> ids = Arrays.asList(DimensionManager.getStaticDimensionIDs());
        Collections.sort(ids);
        String[] dimIDs = new String[ids.size()];
        for (int id : ids) {
            dimIDs[i] = id + "";
            this.dataDimIDs.put(i, id);
            if (id == this.task.dimensionID) {
                p = i;
            }
            ++i;
        }
        button = new GuiNpcButton(4, x + 8, y - 1, 30, 16, dimIDs, p);
        button.setHoverText(new TextComponentTranslation("quest.hover.compass.dim", new Object[0]).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId, "P:", x + 40, y + 2));
        textField = new GuiNpcTextField(9, this, this.field_146289_q, x + 47, y, 32, 14, "" + this.task.regionID);
        textField.setMinMaxDefault(Integer.MIN_VALUE, Integer.MAX_VALUE, this.task.regionID);
        textField.setHoverText(new TextComponentTranslation("quest.hover.compass.reg", new Object[]{this.task.regionID}).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId, "N:", x + 81, y + 2));
        textField = new GuiNpcTextField(15, this, this.field_146289_q, x + 89, y, 123, 14, this.task.entityName);
        textField.setHoverText(new TextComponentTranslation("quest.hover.compass.entity", new Object[0]).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        button = new GuiNpcButton(10, x + 150, y += 16, 60, 16, "gui.set");
        button.setHoverText(new TextComponentTranslation("quest.hover.compass.set", new Object[0]).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(11, x + 128, y, 20, 16, "TP");
        button.setHoverText("hover.teleport", new Object[0]);
        this.addButton(button);
        button = new GuiNpcCheckBox(5, x, y - 2, 123, 16, "quest.set.minimap.point", null, this.task.isSetPointOnMiniMap());
        button.setHoverText("quest.hover.set.minimap.point", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void save() {
        this.task.setTargetName(this.getTextField(0).getFullText());
        this.task.setMaxProgress(this.getTextField(1).getInteger());
        for (QuestObjective taskObj : NoppesUtilServer.getEditingQuest((EntityPlayer)this.player).questInterface.tasks) {
            if (taskObj == this.task || taskObj.getEnumType() != this.task.getEnumType() || !taskObj.getTargetName().equals(this.task.getTargetName())) continue;
            this.getTextField(0).setFullText("");
            this.task.setTargetName("");
            this.task.setMaxProgress(1);
            break;
        }
        if (this.task.getTargetName().isEmpty()) {
            NoppesUtilServer.getEditingQuest((EntityPlayer)this.player).questInterface.removeTask(this.task);
        } else if (((GuiNPCManageQuest)GuiNPCManageQuest.Instance).subgui instanceof GuiQuestEdit) {
            GuiQuestEdit subgui = (GuiQuestEdit)((GuiNPCManageQuest)GuiNPCManageQuest.Instance).subgui;
            subgui.setSubGui(null);
            subgui.func_73866_w_();
        }
    }

    private void saveTargets() {
        this.task.setTargetName(this.getTextField(0).getFullText());
        this.task.setMaxProgress(this.getTextField(1).getInteger());
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        String name = Util.instance.deleteColor(scroll.getSelected());
        this.getTextField(0).setFullText(name);
        if (this.dataNPCs.containsKey(scroll.getSelected())) {
            EntityNPCInterface npcIn = this.dataNPCs.get(scroll.getSelected());
            this.task.dimensionID = npcIn.field_70170_p.field_73011_w.getDimension();
            this.task.pos = npcIn.func_180425_c();
            this.task.entityName = name;
            int range = 5;
            if (npcIn.ais.getMovingType() == 1) {
                range = npcIn.ais.getWanderingRange();
            } else if (npcIn.ais.getMovingType() == 2) {
                int xm = Integer.MAX_VALUE;
                int xn = Integer.MIN_VALUE;
                int ym = Integer.MAX_VALUE;
                int yn = Integer.MIN_VALUE;
                int zm = Integer.MAX_VALUE;
                int zn = Integer.MIN_VALUE;
                for (int[] pos : npcIn.ais.getMovingPath()) {
                    if (xm > pos[0]) {
                        xm = pos[0];
                    }
                    if (xn < pos[0]) {
                        xn = pos[0];
                    }
                    if (ym > pos[1]) {
                        ym = pos[1];
                    }
                    if (yn < pos[1]) {
                        yn = pos[1];
                    }
                    if (zm > pos[2]) {
                        zm = pos[2];
                    }
                    if (zn >= pos[2]) continue;
                    zn = pos[2];
                }
                if (xm != Integer.MAX_VALUE) {
                    if (xm == xn) {
                        this.task.pos = new BlockPos(xm, ym, zm);
                    } else {
                        this.task.pos = new BlockPos(xm + (xn - xm) / 2, ym + (yn - ym) / 2, zm + (zn - zm) / 2);
                        range = 5 + Math.max(xn - xm, Math.max(yn - ym, zn - zm)) / 2;
                    }
                }
            }
            this.task.regionID = BorderController.getInstance().getRegionID(this.task.dimensionID, this.task.pos);
            this.task.setAreaRange(Math.max(range, 32));
        } else {
            this.task.dimensionID = this.player.field_70170_p.field_73011_w.getDimension();
            this.task.pos = BlockPos.field_177992_a;
            this.task.entityName = "";
            this.task.regionID = BorderController.getInstance().getRegionID(this.task.dimensionID, this.player.func_180425_c());
            this.task.setAreaRange(5);
        }
        this.saveTargets();
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        if (this.task == null) {
            return;
        }
        switch (textField.getID()) {
            case 0: {
                this.task.setTargetName(textField.getFullText());
                break;
            }
            case 1: {
                this.task.setMaxProgress(textField.getInteger());
                break;
            }
            case 2: {
                this.task.setAreaRange(textField.getInteger());
                break;
            }
            case 9: {
                if (!BorderController.getInstance().regions.containsKey(textField.getInteger())) {
                    textField.setFullText("" + textField.getDefault());
                    return;
                }
                this.task.regionID = textField.getInteger();
                textField.setHoverText(new TextComponentTranslation("quest.hover.compass.reg", new Object[]{"" + this.task.regionID}).func_150257_a((ITextComponent)new TextComponentTranslation("quest.hover.compass", new Object[0])).func_150254_d(), new Object[0]);
                break;
            }
            case 10: {
                this.task.pos = new BlockPos(textField.getInteger(), this.task.pos.func_177956_o(), this.task.pos.func_177952_p());
                break;
            }
            case 11: {
                this.task.pos = new BlockPos(this.task.pos.func_177958_n(), textField.getInteger(), this.task.pos.func_177952_p());
                break;
            }
            case 12: {
                this.task.pos = new BlockPos(this.task.pos.func_177958_n(), this.task.pos.func_177956_o(), textField.getInteger());
                break;
            }
            case 14: {
                this.task.rangeCompass = textField.getInteger();
                break;
            }
            case 15: {
                this.task.entityName = textField.getFullText();
            }
        }
    }
}

